#include <QTranslator>
#include <QTimer>
#include "SampleWindow.h"
#include "ui_SampleWindow.h"


SampleWindow::SampleWindow(QWidget *parent) :
    QMainWindow(parent), ui(new Ui::SampleWindow) {
    ui->setupUi(this);


    auto translator = new QTranslator();
    if(!translator->load(":/trans/zh_CN")){
        qDebug() << "Translation Error!";
        QTimer::singleShot(1000,[](){QApplication::exit(-1);});
    }

    connect(ui->changeButton,&QPushButton::clicked, [this,translator](){
        static bool isChinese = false;
        if(isChinese) QApplication::removeTranslator(translator);
        else QApplication::installTranslator(translator);
        isChinese = !isChinese;
        ui->retranslateUi(this);
    });
}

SampleWindow::~SampleWindow() {
    delete ui;
}
